clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

a=3e-3;            %raggio membrana [m]
r=linspace(0,a,1000);
s=50*1e-6;          %spessore membrana [m]

E=2e11;                          %Modulo di Young [N/m^2]
nu=0.28;                         %Coeff. di Poisson
D=E*s^3/(12*(1-nu^2));         %Rigidezza [N/m]
% D=64*pi*E*(s)^3/(12*(1+nu^2)*a^2);         %Rigidezza [N/m]

load Misurazioni_laser.mat
[x_max, i_x]=max(x_laser);
i_start=70;
[p_max, i_max]=max(p_relativa);

%% Carico distribuito

for i=1:length(p_relativa)
    p=p_relativa(i);
    %incastro
    w(i,:)=p/(64*D)*(a^2-r.^2).^2;
    z=50;
    w_medio_c(i,:)=mean(w(i,1:z));
    %appoggio
    w2(i,:)=p/(64*D)*(a^2-r.^2).*((5+nu)/(1+nu).*a^2-r.^2);
    w_medio_a(i,:)=mean(w2(i,1:z));

    %lastra sottilissima, incastro
    w_s_c(i,:)=0.662*a*(p*a/(E*s))^(1/3);
    %w_medio_s_c(i,:)=mean(w_s_c(i,1:z));
    %lastra sottilissima, appoggio
    w_s_a(i,:)=0.721*a*(p*a/(E*s))^(1/3);
    %w_medio_s_a(i,:)=mean(w_s_a(i,1:z));
end


% myfittype = fittype('k1*3e-3*(p_relativa*3e-3/(2e11*10*1e-6))^(1/3)','independent',{'p_relativa'},'coefficients',{'k1'});
% myfit = fit (p_relativa(i_start:100:i_max),w_s_c(i_start:100:i_max), myfittype)
k1=1.2;
w_s_fit=k1*a*(p_relativa*a/(E*s)).^(1/3);
w_max_s_fit=max(w_s_fit);
p_rel_laser=p_relativa-0;

figure
% plot(p_relativa(1:i_max),w_medio_c(1:i_max)*1e6,'-','linewidth',2),grid on, hold on,
% plot(p_relativa(1:i_max),w_medio_a(1:i_max)*1e6,'-','linewidth',2),grid on, hold on,
plot(p_rel_laser(i_start:i_max),x_laser(i_start:i_max)*1e6,'-','linewidth',2),grid on, hold on,
plot(p_relativa(i_start:i_max),w_s_c(i_start:i_max)*1e6,'--','linewidth',2),grid on, hold on,
plot(p_relativa(i_start:i_max),w_s_a(i_start:i_max)*1e6,'--','linewidth',2),grid on, hold on,
plot(p_relativa(i_start:i_max),w_s_fit(i_start:i_max)*1e6,'--','linewidth',2),grid on, hold on,
xlabel('Pressione relativa [Pa] '),ylabel('Deflessione media [um]')
grid on, zoom on,title('Carico distribuito')
legend('misura','incastro sottilissime','appoggio sottilissime','curva fittata sottilissime')

% visualizzazione area scelta

p_prova=linspace(4,6,3)*1e5;

for i=1:length(p_prova)
    p1=p_prova(i);
    w_c(i,:)=p1/(64*D)*(a^2-r.^2).^2;
end

j_pressione=1;    %1=4bar, 2=5bar, 3=6bar

figure
plot(r*1e3,-w_c*1e6,'-','linewidth',2),grid on, hold on,
plot(r(1:z)*1e3,-w_c(j_pressione,1:z)*1e6,'x'),grid on, hold on,
plot(r(1)*1e3,-x_max*1e6,'o','Linewidth',4),grid on, hold on,
xlabel('Raggio [mm] '),ylabel('Deflessione [um]')
grid on, zoom on,title('Carico distribuito')
legend('4 bar','5 bar','6 bar','punti considerati','deflessione massima')

%% CALCOLO RIGIDEZZA

%scarto_x=70*1e-6;
stiffness_theoric=pi*a^2*p_prova(j_pressione)./w_max_s_fit  %N/m 
stiffness_measured=pi*a^2*p_prova(j_pressione)./(x_max)  %N/m 